<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
         $elemento       = $geecomDb->leggiSingolaRiga("geec_campagneBanner",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
         $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_banner",$elemento["idBanner"]);
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione invito all'azione</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Campagna modififcata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Banner</a></li>
                                        <li class="breadcrumb-item"><a href="creaBanner.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["nome"] : "Nuova campagna"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="creaBanner.php?id=<?php echo $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">

                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                <input type="text" class="d-none" name="idElemento" value="<?php echo($elemento["id"]); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="col-md-6 form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo $elemento["nome"] ?>" placeholder="Nome occorrenza">
                                                    </div>
                                                    
                                                    <div class="col-md-6 form-group">
                                                        <label>Link</label>
                                                        <input type="text" class="form-control" name="link" value="<?php echo $elemento["link"] ?>" placeholder="Link">
                                                        <small class="text-muted">Il link a cui punterà il banner</small>
                                                    </div>
                                                    
                                                    <div class="col-md-3 form-group">
                                                        <label class="d-block">Attiva</label>
                                                        <input type="checkbox" class="js-switch" name="attiva" value="si" <?php echo(($elemento["attiva"]=="si") ? "checked":"") ?>>
                                                    </div>
                                                </form>    
                                                    <div class="w-100"></div>
                                                    
                                                    <div class="col-lg-6">
                                                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                                                <a class="card-title">
                                                                    Immagine desktop
                                                                </a>
                                                            </div>
                                                            <div id="ImmagineInEvidenza" class="collapse show">
                                                                <div class="card-body">
                                                                    <div class="img-container">
                                                                        <div class="azioni">
                                                                            <div class="btn-group" role="group" aria-label="">
                                                                                <button onclick="eliminaImmagineDesktop()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                                            </div>
                                                                        </div>
                                                                        <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo(($elemento["immagine"]!="") ? $elemento["immagine"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                                    </div>

                                                                    <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                                                    <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                                        <div class="dz-message">
                                                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                                            <h5>Trascina o carica qui l'immagine</h5>
                                                                        </div>
                                                                        <div class="fallback">
                                                                            <input name="file" type="file" />
                                                                        </div>
                                                                    </form>
                                                                    <small>Carica un'immagine ottimizzata per risoluzioni maggiori o uguali a 768px</small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                                                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                                                <a class="card-title">
                                                                    Immagine mobile
                                                                </a>
                                                            </div>
                                                            <div id="ImmagineInEvidenza" class="collapse show">
                                                                <div class="card-body">
                                                                    <div class="img-container">
                                                                        <div class="azioni">
                                                                            <div class="btn-group" role="group" aria-label="">
                                                                                <button onclick="eliminaImmagineMobile()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                                            </div>
                                                                        </div>
                                                                        <img id="immagine2" class="img-fluid w-100 mb-3" src="../../../<?php echo(($elemento["immagineMobile"]!="") ? $elemento["immagineMobile"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                                                    </div>

                                                                    <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmaginiMobile()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                                                    <form action="controller/controllerComponente.php" id="frmFileUpload-01" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                                        <div class="dz-message">
                                                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                                            <h5>Trascina o carica qui l'immagine</h5>
                                                                        </div>
                                                                        <div class="fallback">
                                                                            <input name="file" type="file" />
                                                                        </div>
                                                                    </form>
                                                                    <small>Carica un'immagine ottimizzata per smartphone</small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
        ?>
        <div id="modal-seleziona-foto-mobile" class="modal fade" tabindex="-1" aria-labelledby="aggiungi un componente" aria-hidden="true" role="dialog">
            <div class="modal-dialog modal-xl" role="document">

              <!-- Modal content-->
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Seleziona immagine in evidenza</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                          <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body py-1">
                      <div class="form-row" id="divSelezioneFotoMobile">

                      </div> 
                      <div class="text-center mb-3" id="divBottoneModalSelezionaFotoMobile">
                          <button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmaginiMobile(18,18)">Mostra altre immagini</button>
                      </div>
                  </div>
                  <div class="modal-footer">
                      <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Chiudi</button>
                  </div>
              </div>
            </div>
          </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>

        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineDesktop",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            $("#frmFileUpload-01").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagine2").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineMobile",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmaginiMobile() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltroBannerMobile",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFotoMobile").innerHTML = codice;
                        $('#modal-seleziona-foto-mobile').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                modificaImmagineElementoComponente(<?php echo $elemento["id"] ?>,percorso);
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function cambiaImmagineMobileDaPopup(percorso) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaImmagineMobileConPercorso",
                        idElemento:<?php echo $elemento["id"] ?>,
                        percorso:percorso
                    },
                    success:function(risposta) {
                        if(risposta=="ok") {
                            document.getElementById("immagine2").src = "../../../"+percorso;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
                $('#modal-seleziona-foto-mobile').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiungiImmaginiModalSelezioneImmaginiMobile(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltroBannerMobile",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFotoMobile").innerHTML; 
                        document.getElementById("divSelezioneFotoMobile").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFotoMobile").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmaginiMobile('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaImmagineDesktop() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagineElemento",
                        idElemento:<?php echo $elemento["id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaImmagineMobile() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagineMobile",
                        idElemento:<?php echo $elemento["id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagine2").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
